#include "Skybox.h"

Skybox::Skybox(ID3D11Device* device, ID3D11DeviceContext* deviceContext)
{
	//Set the vertex and indices count, initialize the buffers and create the shape
	vertexCount = 24;
	indexCount = 36;

	initBuffers(device);
	CreateShape();
}

Skybox::~Skybox()
{

}

void Skybox::initBuffers(ID3D11Device* device)
{
	_Device = device;
	_Vertices = new VertexType[vertexCount];
	_Indices = new long[indexCount];
}

void Skybox::CreateFrontFace()
{
	topLeft.position = XMFLOAT3(1.0f, 1.0f, -1.0f);
	topLeft.texture = XMFLOAT2(0.75f, 0.25f);
	topLeft.normal = XMFLOAT3(0.0f, 0.0f, 1.0f);

	topRight.position = XMFLOAT3(0.0f, 1.0f, -1.0f);
	topRight.texture = XMFLOAT2(1.0f, 0.25f);
	topRight.normal = XMFLOAT3(0.0f, 0.0f, 1.0f);

	bottomLeft.position = XMFLOAT3(1.0f, 0.0f, -1.0f);
	bottomLeft.texture = XMFLOAT2(0.75f, 0.5f);
	bottomLeft.normal = XMFLOAT3(0.0f, 0.0f, 1.0f);

	bottomRight.position = XMFLOAT3(0.0f, 0.0f, -1.0f);
	bottomRight.texture = XMFLOAT2(1.0f, 0.5f);
	bottomRight.normal = XMFLOAT3(0.0f, 0.0f, 1.0f);

	_Vertices[4] = topLeft;
	_Vertices[5] = bottomLeft;
	_Vertices[6] = bottomRight;
	_Vertices[7] = topRight;

	_Indices[6] = 4;
	_Indices[7] = 5;
	_Indices[8] = 7;
	_Indices[9] = 7;
	_Indices[10] = 5;
	_Indices[11] = 6;
}


void Skybox::CreateBackFace()
{
	topLeft.position = XMFLOAT3(0.0f, 1.0f, 0.0f);
	topLeft.texture = XMFLOAT2(0.25f, 0.25f);
	topLeft.normal = XMFLOAT3(0.0f, 0.0f, -1.0f);

	topRight.position = XMFLOAT3(1.0f, 1.0f, 0.0f);
	topRight.texture = XMFLOAT2(0.5f, 0.25f);
	topRight.normal = XMFLOAT3(0.0f, 0.0f, -1.0f);

	bottomLeft.position = XMFLOAT3(0.0f, 0.0f, 0.0f);
	bottomLeft.texture = XMFLOAT2(0.25f, 0.5f);
	bottomLeft.normal = XMFLOAT3(0.0f, 0.0f, -1.0f);

	bottomRight.position = XMFLOAT3(1.0f, 0.0f, 0.0f);
	bottomRight.texture = XMFLOAT2(0.5f, 0.5f);
	bottomRight.normal = XMFLOAT3(0.0f, 0.0f, -1.0f);

	_Vertices[0] = topLeft;
	_Vertices[1] = bottomLeft;
	_Vertices[2] = bottomRight;
	_Vertices[3] = topRight;

	_Indices[0] = 0;
	_Indices[1] = 1;
	_Indices[2] = 3;
	_Indices[3] = 3;
	_Indices[4] = 1;
	_Indices[5] = 2;
}



void Skybox::CreateLeftFace()
{
	topLeft.position = XMFLOAT3(0.0f, 1.0f, -1.0f);
	topLeft.texture = XMFLOAT2(0.0f, 0.25f);
	topLeft.normal = XMFLOAT3(1.0f, 0.0f, 0.0f);

	topRight.position = XMFLOAT3(0.0f, 1.0f, 0.0f);
	topRight.texture = XMFLOAT2(0.25f, 0.25f);
	topRight.normal = XMFLOAT3(1.0f, 0.0f, 0.0f);

	bottomLeft.position = XMFLOAT3(0.0f, 0.0f, -1.0f);
	bottomLeft.texture = XMFLOAT2(0.0f, 0.5f);
	bottomLeft.normal = XMFLOAT3(1.0f, 0.0f, 0.0f);

	bottomRight.position = XMFLOAT3(0.0f, 0.0f, 0.0f);
	bottomRight.texture = XMFLOAT2(0.25f, 0.5f);
	bottomRight.normal = XMFLOAT3(1.0f, 0.0f, 0.0f);

	_Vertices[8] = topLeft;
	_Vertices[9] = bottomLeft;
	_Vertices[10] = bottomRight;
	_Vertices[11] = topRight;

	_Indices[12] = 8;
	_Indices[13] = 9;
	_Indices[14] = 11;
	_Indices[15] = 11;
	_Indices[16] = 9;
	_Indices[17] = 10;
}

void Skybox::CreateRightFace()
{
	topLeft.position = XMFLOAT3(1.0f, 1.0f, 0.0f);
	topLeft.texture = XMFLOAT2(0.5f, 0.25f);
	topLeft.normal = XMFLOAT3(-1.0f, 0.0f, 0.0f);

	topRight.position = XMFLOAT3(1.0f, 1.0f, -1.0f);
	topRight.texture = XMFLOAT2(0.75f, 0.25f);
	topRight.normal = XMFLOAT3(-1.0f, 0.0f, 0.0f);

	bottomLeft.position = XMFLOAT3(1.0f, 0.0f, 0.0f);
	bottomLeft.texture = XMFLOAT2(0.5f, 0.5f);
	bottomLeft.normal = XMFLOAT3(-1.0f, 0.0f, 0.0f);

	bottomRight.position = XMFLOAT3(1.0f, 0.0f, -1.0f);
	bottomRight.texture = XMFLOAT2(0.75f, 0.5f);
	bottomRight.normal = XMFLOAT3(-1.0f, 0.0f, 0.0f);

	_Vertices[12] = topLeft;
	_Vertices[13] = bottomLeft;
	_Vertices[14] = bottomRight;
	_Vertices[15] = topRight;

	_Indices[18] = 12;
	_Indices[19] = 13;
	_Indices[20] = 15;
	_Indices[21] = 15;
	_Indices[22] = 13;
	_Indices[23] = 14;
}

void Skybox::CreateTopFace()
{
	topLeft.position = XMFLOAT3(0.0f, 1.0f, -1.0f);
	topLeft.texture = XMFLOAT2(0.25f, 0.0f);
	topLeft.normal = XMFLOAT3(0.0f, -1.0f, 0.0f);

	topRight.position = XMFLOAT3(1.0f, 1.0f, -1.0f);
	topRight.texture = XMFLOAT2(0.5f, 0.0f);
	topRight.normal = XMFLOAT3(0.0f, -1.0f, 0.0f);

	bottomLeft.position = XMFLOAT3(0.0f, 1.0f, 0.0f);
	bottomLeft.texture = XMFLOAT2(0.25f, 0.25f);
	bottomLeft.normal = XMFLOAT3(-0.0f, -1.0f, 0.0f);

	bottomRight.position = XMFLOAT3(1.0f, 1.0f, 0.0f);
	bottomRight.texture = XMFLOAT2(0.5f, 0.25f);
	bottomRight.normal = XMFLOAT3(0.0f, -1.0f, 0.0f);

	_Vertices[16] = topLeft;
	_Vertices[17] = bottomLeft;
	_Vertices[18] = bottomRight;
	_Vertices[19] = topRight;

	_Indices[24] = 16;
	_Indices[25] = 17;
	_Indices[26] = 19;
	_Indices[27] = 19;
	_Indices[28] = 17;
	_Indices[29] = 18;
}

void Skybox::CreateBottomFace()
{
	topLeft.position = XMFLOAT3(0.0f, 0.0f, 0.0f);
	topLeft.texture = XMFLOAT2(0.25f, 0.5f);
	topLeft.normal = XMFLOAT3(0.0f, 1.0f, 0.0f);

	topRight.position = XMFLOAT3(1.0f, 0.0f, 0.0f);
	topRight.texture = XMFLOAT2(0.5f, 0.5f);
	topRight.normal = XMFLOAT3(0.0f, 1.0f, 0.0f);

	bottomLeft.position = XMFLOAT3(0.0f, 0.0f, -1.0f);
	bottomLeft.texture = XMFLOAT2(0.25f, 0.75f);
	bottomLeft.normal = XMFLOAT3(0.0f, 1.0f, 0.0f);

	bottomRight.position = XMFLOAT3(1.0f, 0.0f, -1.0f);
	bottomRight.texture = XMFLOAT2(0.5f, 0.75f);
	bottomRight.normal = XMFLOAT3(0.0f, 1.0f, 0.0f);

	_Vertices[20] = topLeft;
	_Vertices[21] = bottomLeft;
	_Vertices[22] = bottomRight;
	_Vertices[23] = topRight;

	_Indices[30] = 20;
	_Indices[31] = 21;
	_Indices[32] = 23;
	_Indices[33] = 23;
	_Indices[34] = 21;
	_Indices[35] = 22;
}

void Skybox::CreateShape()
{
	//Create all the faces with the correct vertices, normals, texture coordinates and indices
	CreateFrontFace();
	CreateBackFace();
	CreateLeftFace();
	CreateRightFace();
	CreateTopFace();
	CreateBottomFace();

	D3D11_SUBRESOURCE_DATA vertexData, indexData;

	//Create the vertex buffer
	D3D11_BUFFER_DESC vertexBufferDesc = { sizeof(VertexType) * vertexCount, D3D11_USAGE_DEFAULT, D3D11_BIND_VERTEX_BUFFER, 0, 0, 0 };
	vertexData = { _Vertices, 0 , 0 };
	_Device->CreateBuffer(&vertexBufferDesc, &vertexData, &vertexBuffer);

	//Create the index buffer
	D3D11_BUFFER_DESC indexBufferDesc = { sizeof(unsigned long) * indexCount, D3D11_USAGE_DEFAULT, D3D11_BIND_INDEX_BUFFER, 0, 0, 0 };
	indexData = { _Indices, 0, 0 };
	_Device->CreateBuffer(&indexBufferDesc, &indexData, &indexBuffer);

	//Now cleanup
	delete[] _Vertices;
	_Vertices = 0;
	delete[] _Indices;
	_Indices = 0;
}